library(memisc)
# devtools::load_all("~/R/devel/memisc/pkg")
library(mclogit)
library(magrittr)
rm(list=ls())
load("ESScumul.RData")

options(warn=1)

#debug(selectMethod("recode", "double.item"))
#debug(selectMethod("recode", "item"))

#trace("recode", browser, signature="item")

ESScumul %<>% within({
    country2 <- recode(country,
                       Albania                   =  1 <- 1,
                       Austria                   =  2 <- 2,
                       "Belgium/Wallonia"        =  3 <- 3,
                       "Belgium/Flanders"        =  4 <- 102, # Pseudo code ...
                       "Belgium/Brussels"        =  5 <- 103,
                       Bulgaria                  =  6 <- 4,
                       Croatia                   =  7 <- 5,
                       Cyprus                    =  8 <- 6,
                       Czechia                   =  9 <- 7,
                       Denmark                   = 10 <- 8,
                       Estonia                   = 11 <- 9,
                       Finland                   = 12 <- 10,
                       France                    = 13 <- 11,
                       "Germany (West)"          = 14 <- 12,
                       "Germany/Bavaria"         = 15 <- 104,
                       "Germany (East)"          = 16 <- 13,
                       Greece                    = 17 <- 14,
                       Hungary                   = 18 <- 15,
                       Iceland                   = 19 <- 16,
                       Ireland                   = 20 <- 17,
                       Israel                    = 21 <- 18,
                       Italy                     = 22 <- 19,
                       Kosovo                    = 23 <- 20,
                       Latvia                    = 24 <- 21,
                       Lithuania                 = 25 <- 22,
                       Luxembourg                = 26 <- 23,
                       Montenegro                = 27 <- 24,
                       Netherlands               = 28 <- 25,
                       Norway                    = 29 <- 26,
                       Poland                    = 30 <- 27,
                       Portugal                  = 31 <- 28,
                       Romania                   = 32 <- 29,
                       Russia                    = 33 <- 30,
                       Serbia                    = 34 <- 31,
                       Slovenia                  = 35 <- 32,
                       Slovakia                  = 36 <- 33,
                       "Spain/Castilia"          = 37 <- 34,
                       "Spain/Catalunia"         = 38 <- 105,
                       "Spain/Basque"            = 39 <- 106,
                       Sweden                    = 40 <- 35,
                       Switzerland               = 41 <- 36,
                       Turkey                    = 42 <- 37,
                       Ukraine                   = 43 <- 38,
                       "United Kingdom/England"  = 44 <- 39,
                       "United Kingdom/Scotland" = 45 <- 107,
                       "United Kingdom/Wales"    = 46 <- 108,
                       "United Kinddom/N.Irland" = 47 <- 109,
                       Macedonia                 = 48 <- 40)
    country2[is.valid(flanders) & flanders]   <- 4
    country2[is.valid(brussels) & brussels]   <- 5
    country2[is.valid(bavaria) & bavaria]     <- 15
    country2[is.valid(catalunia) & catalunia] <- 38
    country2[is.valid(basque) & basque]       <- 39
    country2[is.valid(scotland) & scotland]   <- 45
    country2[is.valid(wales) & wales]         <- 46
    country2[is.valid(n.irland) & n.irland]   <- 47
})

codebook(ESScumul$country2)


ESScumul %<>% within({
    measurement(reldenom) <- "nominal"
    reldenom[reldenom.any==2] <- 9
    labels(reldenom) <- labels(reldenom) + c("No religion"=9)
    denom <- recode(reldenom,
                    Catholic          = 1 <- 1,
                    Protestant        = 2 <- 2,
                    Orthodox          = 3 <- 3,
                    "Other Christian" = 4 <- 4,
                    "Non-Christian"   = 5 <- 5:8,
                    "No religion"     = 6 <- 9,
                    copy=TRUE
                    )
    relatt <- recode(relig.attend,
                     Weekly =   5 <- 1:3,
                     Monthly =  4 <- 4,
                     Holidays = 3 <- 5,
                     Rarely =   2 <- 6,
                     Never =    1 <- 7,
                     copy=TRUE)
    pray <- recode(pray,
        Daily = 5 <- 1,
        Weekly = 4 <- 2:3,
        Monthly = 3 <- 4,
        Rarely = 2 <- 5:6,
        Never = 1 <- 7,
        copy = TRUE
    )
    oesch8 <- recode(oesch9,
                     'Self-employed'   = 1 <- 1:2,
                     'Technical'       = 2 <- 3,
                     'Prod. worker'    = 3 <- 4,
                     'Management'      = 4 <- 5,
                     'Clerks'          = 5 <- 6,
                     'Socio-cultural'  = 6 <- 7,
                     'Service worker'  = 7 <- 8,
                     'Primary sector'  = 8 <- 9,
                     'Unclassifiable'  = 99 <- NA)
    valid.values(oesch8) <- 1:8
    w.poststrat[is.na(w.poststrat)] <- 1
    denom[country == "France" & year <= 2005 |
          country == "United Kingdom" & year >= 2004 & year <= 2007] <- NA
})


codebook(ESScumul[c("denom","relatt","oesch8")])

nrow(ESScumul)

ESScumul_christian <- subset(ESScumul,
                             denom %in% 1:4)

source("utils/contract.R")

######


ESS_denom <-
    contract(ESScumul,
             by=w.poststrat ~
                 CHES_id +
                 country2 +
                 year +
                 essround + 
                 denom +
                 oesch8 +
                 gender,
             name="wgt",
             drop.na=FALSE)
nrow(ESS_denom)

ESS_denom %<>% subset(is.finite(CHES_id))
nrow(ESS_denom)


ESS_relatt <-
    contract(ESScumul_christian,
             by=w.poststrat ~
                 CHES_id +
                 country2 +
                 year +
                 essround + 
                 relatt +
                 oesch8 +
                 gender,
             name="wgt",
             drop.na=FALSE)
nrow(ESS_relatt)

ESS_relatt %<>% subset(is.finite(CHES_id))
nrow(ESS_relatt)

ESS_pray <-
    contract(ESScumul_christian,
             by=w.poststrat ~
                 CHES_id +
                 country2 +
                 year +
                 essround + 
                 pray +
                 oesch8 +
                 gender,
             name="wgt",
             drop.na=FALSE)
nrow(ESS_pray)

ESS_pray %<>% subset(is.finite(CHES_id))
nrow(ESS_pray)

ESS_religious <-
    contract(ESScumul_christian,
             by=w.poststrat ~
                 CHES_id +
                 country2 +
                 year +
                 essround + 
                 religious +
                 oesch8 +
                 gender,
             name="wgt",
             drop.na=FALSE)
nrow(ESS_religious)

ESS_religious %<>% subset(is.finite(CHES_id))
nrow(ESS_religious)

###################

ESS_denom_age <-
    contract(ESScumul,
             by=w.poststrat ~
                 CHES_id +
                 country2 +
                 year +
                 essround + 
                 denom +
                 oesch8 +
                 age + 
                 ybirth +
                 gender,
             name="wgt",
             drop.na=FALSE)
nrow(ESS_denom_age)

ESS_denom_age %<>% subset(is.finite(CHES_id))
nrow(ESS_denom_age)

ESS_relatt_age <-
    contract(subset(ESScumul_christian, denom %in% 1:4),
             by=w.poststrat ~
                 CHES_id +
                 country2 +
                 year +
                 essround + 
                 relatt +
                 oesch8 +
                 age + 
                 ybirth +
                 gender,
             name="wgt",
             drop.na=FALSE)
nrow(ESS_relatt_age)

ESS_relatt_age %<>% subset(is.finite(CHES_id))
nrow(ESS_relatt_age)

ESS_relatt_denom <-
    contract(ESScumul,
             by=w.poststrat ~
                 CHES_id +
                 country2 +
                 year +
                 essround + 
                 denom +
                 relatt +
                 oesch8 +
                 gender,
             name="wgt",
             drop.na=FALSE)
nrow(ESS_relatt_denom)

ESS_relatt_denom %<>% subset(is.finite(CHES_id))
nrow(ESS_relatt_denom)

ESS_pray_age <-
    contract(subset(ESScumul_christian, denom %in% 1:4),
             by=w.poststrat ~
                 CHES_id +
                 country2 +
                 year +
                 essround + 
                 pray +
                 oesch8 +
                 age + 
                 ybirth +
                 gender,
             name="wgt",
             drop.na=FALSE)
nrow(ESS_pray_age)

ESS_pray_age %<>% subset(is.finite(CHES_id))
nrow(ESS_pray_age)

ESS_pray_denom <-
    contract(ESScumul,
             by=w.poststrat ~
                 CHES_id +
                 country2 +
                 year +
                 essround + 
                 pray +
                 denom +
                 oesch8 +
                 gender,
             name="wgt",
             drop.na=FALSE)
nrow(ESS_pray_denom)

ESS_pray_denom %<>% subset(is.finite(CHES_id))
nrow(ESS_pray_denom)

ESS_religious_age <-
    contract(subset(ESScumul_christian, denom %in% 1:4),
             by=w.poststrat ~
                 CHES_id +
                 country2 +
                 year +
                 essround + 
                 religious +
                 oesch8 +
                 age + 
                 ybirth +
                 gender,
             name="wgt",
             drop.na=FALSE)
nrow(ESS_religious_age)

ESS_religious_age %<>% subset(is.finite(CHES_id))
nrow(ESS_religious_age)

ESS_religious_denom <-
    contract(ESScumul,
             by=w.poststrat ~
                 CHES_id +
                 country2 +
                 year +
                 essround + 
                 religious +
                 oesch8 +
                 denom + 
                 gender,
             name="wgt",
             drop.na=FALSE)
nrow(ESS_religious_denom)

ESS_religious_denom %<>% subset(is.finite(CHES_id))
nrow(ESS_religious_denom)

ESS_denom_age_novote <-
    contract(ESScumul,
             by=w.poststrat ~
                 country +
                 year +
                 essround + 
                 denom +
                 ybirth +
                 age +
                 gender,
             name="wgt",
             drop.na=FALSE)
nrow(ESS_denom_age_novote)

ESS_relatt_denom_age_novote <-
    contract(ESScumul,
             by=w.poststrat ~
                 country +
                 year +
                 essround + 
                 relatt +
                 denom +
                 ybirth +
                 age +
                 gender,
             name="wgt",
             drop.na=FALSE)
nrow(ESS_relatt_denom_age_novote)


ESS_religious_denom_age_novote <-
    contract(ESScumul,
             by=w.poststrat ~
                 country +
                 year +
                 essround + 
                 religious +
                 denom +
                 ybirth +
                 age +
                 gender,
             name="wgt",
             drop.na=FALSE)
nrow(ESS_religious_denom_age_novote)

ESS_pray_denom_age_novote <-
    contract(ESScumul,
             by=w.poststrat ~
                 country +
                 year +
                 essround + 
                 pray +
                 denom +
                 ybirth +
                 age +
                 gender,
             name="wgt",
             drop.na=FALSE)
nrow(ESS_pray_denom_age_novote)

save(ESS_denom,
     ESS_denom_age,
     ESS_relatt,
     ESS_relatt_age,
     ESS_relatt_denom,
     ESS_pray,
     ESS_pray_age,
     ESS_pray_denom,
     ESS_religious,
     ESS_religious_age,
     ESS_religious_denom,
     file="ESS-relig.RData")

save(ESS_denom_age_novote,
     ESS_relatt_denom_age_novote,
     ESS_religious_denom_age_novote,
     ESS_pray_denom_age_novote,
     file="ESS-relig-novote.RData")
